% Generate function for asymmetric facilitative transporter with 3 substrates

clear
syms Xt JX CX1 CX2 kX12 kX21 JAX CA1 CA2 CAX1 CAX2 KA1 KA2 kA12 kA21 JBX CB1 CB2 CBX1 CBX2 KB1 KB2 kB12 kB21 JCX CC1 CC2 CCX1 CCX2 KC1 KC2 kC12 kC21
S=solve(CA1*CX1/(KA1*CAX1)==1,CB1*CX1/(CBX1*KB1)==1,CC1*CX1/(CCX1*KC1)==1,CA2*CX2/(CAX2*KA2)==1,CB2*CX2/(CBX2*KB2)==1,CC2*CX2/(CCX2*KC2)==1,CAX1+CAX2+CBX1+CBX2+CCX1+CCX2+CX1+CX2-Xt==0,JX+JAX+JBX+JCX==0,kX12*CX1-kX21*CX2-JX==0,kA12*CAX1-kA21*CAX2-JAX==0,kB12*CBX1-kB21*CBX2-JBX==0,kC12*CCX1-kC21*CCX2-JCX==0,CAX1,CBX1,CCX1,CAX2,CBX2,CCX2,CX1,CX2,JX,JCX,JBX,JAX);
S.JAX
S.JBX
S.JCX

% constraint facilitative is clockwise and anticlockwise product including the carrier the same for each substrate

% constraint exchanger is that ratio between forward and backward products is the same for each substrate (also implies clockwise and anticlockwise is the same for exchange A for B)

%create function file:
f=matlabFunction(S.JAX,'file','FacfuncJAX');
f=matlabFunction(S.JBX,'file','FacfuncJBX');
f=matlabFunction(S.JCX,'file','FacfuncJCX');

